/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $ */

'use strict';

require.config({
    // 3rd party script alias names (Easier to type "jquery" than "libs/jquery, etc")
    // probably a good idea to keep version numbers in the file names for updates checking
    paths: {
        // Core Libraries
        "jquery": "test/libs/jquery/jquery-1.9.1",
        "jqueryui": "test/libs/jqueryui/jqueryui-1.9.2",
        "jquerymobile": "test/libs/jqm/jquery.mobile-1.3.1",
        "underscore": "test/libs/marionette/lodash-1.3.1", // 2.4.1 // 1.3.1
        "backbone": "test/libs/marionette/backbone-1.0.0-custom", // 1.1.0 // 1.0.0
        "marionette": "test/libs/marionette/backbone.marionette-1.1.0", // 1.4.0
        "handlebars": "test/libs/handlebars/handlebars-1.0.0",
        "hbs": "test/libs/handlebars/hbs-0.4.0",
        "i18nprecompile": "test/libs/handlebars/i18nprecompile",
        "json2": "test/libs/marionette/json2",
        "jasmine": "test/libs/jasmine/jasmine-1.3.1",
        "jasmine-html": "test/libs/jasmine/jasmine-html-1.3.1",
        "moment": "test/libs/moment/moment-2.4.0.min",

        // Theming
        "jquerymobile-config": "test/libs/jqm/jquery.mobile-config",

        // Plugins
        "text": "test/libs/require/plugins/text",
        "jasminejquery": "test/libs/jquery/plugins/jasmine-jquery",
        "jquery.form": "test/libs/jquery/plugins/jquery.form.min-20130616",
        "jquerymobile-autocomplete": "test/libs/jqm/jqm-autocomplete/jquery.mobile.accessible-autocomplete",
        "jquerymobile-datepicker": "test/libs/jqm/jqm-datepicker/jquery.accessibleDatePicker",

        "applets/search-applet": ".",
        "Portal": "test/mock/Portal",

        // Test directory
        "test": "test"
    },
    // Sets the configuration for your third party scripts that are not AMD compatible
    shim: {
        "jquerymobile": {
            deps: ["jquery", "jquerymobile-config"]
        },
        "jquerymobile-autocomplete": {
            deps: ["jquery", "jquerymobile"]
        },
        "jquerymobile-datepicker": {
            deps: ["jquery", "jquerymobile"]
        },
        "backbone": {
            "deps": ["underscore", "jquery"],
            "exports": "Backbone"
        },
        "marionette": {
            "deps": ["underscore", "backbone", "jquery"],
            "exports": "Marionette"
        },
        "handlebars": {
            "exports": "Handlebars"
        },
        "jasmine": {
            "exports": "jasmine"
        },
        "jasmine-html": {
            "deps": ["jasmine"],
            "exports": "jasmine"
        }
    },
    // hbs config - must duplicate in Gruntfile.js Require build
    hbs: {
        templateExtension: "html",
        disableI18n: false,
        disableHelpers: false,
        helperDirectory: "_assets/templates/helpers/",
        i18nDirectory: "_assets/templates/i18n/",

        compileOptions: {}        // options object which is passed to Handlebars compiler
    }
});
